﻿
var dummy_id = 0;

// 警告を出さない
fl.showIdleMessage( false );

// ---------------------------------------------------------
// Flash ファイルの ActionScript のバージョンを取得
// ---------------------------------------------------------
function GetAsVersionFunc(){
	var ver = 0;
	var doc = fl.getDocumentDOM();
	if(doc){
		var val = doc.asVersion;
		if(val)	ver = val;
	}

	return ver;
}



// ---------------------------------------------------------
// アイテムが選択常態か調べる
// ---------------------------------------------------------
function ItemGetSelect(item){
	var doc = fl.getDocumentDOM();
	if(!doc)	return false;

	var lib = doc.library;

	// 選択中のアイテム
	var items = lib.getSelectedItems();
	var num = items.length;

	for(var i=0;i<num;i++){
		if(item == items[i])	return true;
	}
	
	return false;
}


// ---------------------------------------------------------
// アイテムが識別子を保有するか調べる
// ---------------------------------------------------------
function ItemGetAsset(item){
	if(item.linkageImportForRS)		return true;
	if(item.linkageExportForAS)		return true;
	if(item.linkageExportForRS)		return true;
	return false;
}


// ---------------------------------------------------------
// リンケージプロパティを設定
// ---------------------------------------------------------
function LinkageUpdate(param){

	var ver = Number(param.ver);		// AS バージョン
	var check0 = param.check0;			// チェック0
	var check1 = param.check1;			// チェック1
	var check2 = param.check2;			// チェック2
	var check3 = param.check3;			// チェック3
	var asset = param.asset;			// 識別子（クラス名）
	var start_num = param.start_num;	// 連番開始番号
	var asset_type = param.asset_type;	// 識別子タイプ
	var class_name = param.class_name;	// AS2.0クラス名（基本クラス名）
	var class_type = param.class_type;	// クラス名の最後にシンボル名を付加するか
	var url = param.url;				// URL
	var dir_type = param.dir_type;		// フォルダを含める
	var doc = fl.getDocumentDOM();
	if(!doc)	return false;
	
	var lib = doc.library;

	var select_container	= LinkedListContainerCreate();	// 選択状態の双方向リストコンテナ
	var unselect_container	= LinkedListContainerCreate();	// 未選択状態双方向リストコンテナ

	var items = lib.items;
	var num = items.length;
	var i;
	for(i=0;i<num;i++){
		var item = items[i];
		
		// フォルダなら次へ
		if(item.itemType == "folder")	continue;
		
		var data = new Object();
		data.item = item;
		data.name = item.name;
		data.item_name = StringGetName(item.name);
		data.select = ItemGetSelect(item);
		data.asset_type = ItemGetAsset(item);
		data.asset_old = null;
		data.asset_new = null;


		var list = LinkedListCreate();
		LinkedListSetData(list,data);
		
		// 登録するコンテナ
		var container;
		if(data.select)		container = select_container;
		else				container = unselect_container;

		// 名前でバブルソートしつつコンテナに登録
		var post = LinkedListContainerGetDataStack(container,function(list,param){
			var dat = LinkedListGetData(list);
			if(StringComp(dat.name,param) < 0)		return true;
			else									return false;
		},data.name);
		if(post)	LinkedListAttachPref(post,list);
		else		LinkedListContainerAttachPush(container,list);
	}

	// 現在の識別子をセット
	var AssetSetOldNameFunc = function(list,param){
		var dat = LinkedListGetData(list);
		if(dat.asset_type)	dat.asset_old = dat.item.linkageIdentifier;
		else				dat.asset_old = dat.item_name;
		return false;
	};
	LinkedListContainerGetData(select_container,AssetSetOldNameFunc,null);
	LinkedListContainerGetData(unselect_container,AssetSetOldNameFunc,null);

	// リネーム後の識別子をセット
	if(asset_type == 0){
		// 連番を使用する
		LinkedListContainerGetData(select_container,function(list,param){
			var dat = LinkedListGetData(list);
			dat.asset_new = param.asset + param.num;
			param.num ++;
			return false;
		},{asset:asset,num:start_num});
	}else if(asset_type == 1){
		// シンボル名を使用する
		LinkedListContainerGetData(select_container,function(list,param){
			var dat = LinkedListGetData(list);
			dat.asset_new = (dir_type) ? dat.name : StringGetName(dat.name);
			return false;
		},null);
	}
	LinkedListContainerGetData(unselect_container,function(list,param){
		var dat = LinkedListGetData(list);
		dat.asset_new = dat.asset_old;
		return false;
	},null);

	// ハッシュテーブルを作成
	var old_hash_container = HashContainerCreate(2);
	var new_hash_container = HashContainerCreate(2);
	
	// 識別子をハッシュテーブルに登録
	var LinkedListSetHashFunc = function(list,param){
		var dat = LinkedListGetData(list);
		var name_hash = StringGetHash(dat.name);
		var item_name_hash = StringGetHash(dat.item_name);
		var old_hash = StringGetHash(dat.asset_old);
		var new_hash = StringGetHash(dat.asset_new);
		dat.name_hash = name_hash;
		dat.item_name_hash = item_name_hash;
		dat.old_hash = old_hash;
		dat.new_hash = new_hash;
		HashContainerAttachData(old_hash_container,dat,old_hash);
		HashContainerAttachData(new_hash_container,dat,new_hash);
		return false;
	};
	LinkedListContainerGetData(select_container,LinkedListSetHashFunc,null);
	LinkedListContainerGetData(unselect_container,LinkedListSetHashFunc,null);

	switch(ver){
	case 0:
	case 1:
	case 2:

		var check = true;

		//識別子を持たせるときに衝突するか調べる
		var ret = LinkedListContainerGetData(select_container,function(list,param){
			var dat = LinkedListGetData(list);
			// 衝突先にリネームの予定が無い
			return HashContainerGetData(old_hash_container,dat.item_name_hash,function(dat,param){
				if(dat == param)	return false;
				if(dat.asset_old == param.item_name){
					if(dat.asset_new == param.item_name){
						fl.trace("【エラー１】\n\t解決:シンボル名『" + dat.name + "』の識別子を『" + dat.asset_new + "』以外に変更してください。\n\t原因：シンボル『"+ param.name + "』の設定クリア時に識別子『"+ dat.asset_new +"』が衝突します。")
						return true;
					}
				}
				return false;
			},dat);
			return false;
		},null);
		if(ret)	check = false;

		// 識別子を持たせるときに衝突するか調べる
		var ret = LinkedListContainerGetData(select_container,function(list,param){
			var dat = LinkedListGetData(list);
			// リネーム後の名称と衝突する
			return HashContainerGetData(new_hash_container,dat.item_name_hash,function(dat,param){
				if(dat == param)	return false;
				if(dat.asset_old != dat.asset_new){
					if(dat.asset_new == param.item_name){
						fl.trace("【エラー２】\n\t解決:シンボル名『" + dat.name + "』の識別子を『" + dat.asset_new + "』以外に変更してください。\n\t原因：シンボル『"+ param.name + "』の設定クリア時に識別子『"+ dat.asset_new +"』が衝突します。")
						return true;
					}
				}
				return false;
			},dat);
			return false;
		},null);
		if(ret)	check = false;

		// アイテムのりネーム先が衝突するか調べる
		var ret = LinkedListContainerGetData(select_container,function(list,param){
			var dat = LinkedListGetData(list);
			// 衝突先にリネームの予定が無い
			return HashContainerGetData(old_hash_container,dat.new_hash,function(dat,param){
				if(dat == param)	return false;
				if(dat.asset_old == param.asset_new){
					if(dat.asset_new == param.asset_new){
						fl.trace("【エラー３】\n\t解決:シンボル名『" + dat.name + "』の識別子を『" + dat.asset_new + "』以外に変更してください。\n\t原因：シンボル『"+ param.name + "』とシンボル『"+ dat.name +"』の識別子が衝突します。")
						return true;
					}
				}
				return false;
			},dat);
			return false;
		},null);
		if(ret)	check = false;
		if(!check){
			fl.trace("【中断】変換処理は行われませんでした。");
			return false;
		}

	};

	// 識別子の無いリストが先になるようソート
	LinkedListContainerGetDataStack(select_container,function(list,param){
		var dat = LinkedListGetData(list);
		if(!dat.asset_type){
			LinkedListContainerAttachUnShift(param,list);
		}
		return false;
	},select_container);

	// 選択されたアイテムを変換
	LinkedListContainerGetDataStack(select_container,function(list,param){
		var dat = LinkedListGetData(list);
		
		var item = dat.item;

		var str0 = dat.asset_new;

		// クラス名の最後にシンボル名を付加する
		var str1 = class_name;
		if(class_type == 1){
			str1 = str1 + "." + dat.item_name;
		}

		// 識別子をつける場合
		if(check0 || check1 || check3){


			// ActionScript3.0用設定
			if(ver == 3){

			// ActionScript1.0 & 2.0用設定
			}else{
				// 古い名前と衝突するアイテムがあるか調べる
				HashContainerGetData(old_hash_container,dat.new_hash,function(dat,param){

					if(dat == param)					return false;
					if(dat.item.name == dat.asset_new)	return false;
					if(dat.asset_old == param.asset_new){
						// 重複しないダミーの識別子を取得
						for(;dummy_id<0x7FFFFFFF;){
							var dummy = asset + "_dummy_" + dummy_id;
							var dummy_hath = StringGetHash(dummy);
							var ret1 = HashContainerGetData(old_hash_container,dummy_hath,function(dat,param){
								if(dat.asset_old == param)	return true;
								return false;
							},dummy);

							var ret2 = HashContainerGetData(new_hash_container,dummy_hath,function(dat,param){
								if(dat.asset_new == param)	return true;
								return false;
							},dummy);
							
							dummy_id ++;
							if(!(ret1 || ret2))	break;
						}

						if(!ItemSetAsset(dat.item,dummy)){
							fl.trace("【エラー】シンボル名『" + dat.item.name + "』の識別子入れ替えに必要なダミー名の設定に失敗しました。")
						}
					}

					return false;
				},dat);
			}
		}


		// 初期化
		if(item.linkageImportForRS != undefined)		item.linkageImportForRS = false;
		if(item.linkageExportInFirstFrame != undefined)	item.linkageExportInFirstFrame = false;
		if(item.linkageExportForAS != undefined)		item.linkageExportForAS = false;
		if(item.linkageExportForRS != undefined)		item.linkageExportForRS = false;


		if(check3){
			if(item.linkageExportForRS != undefined)		item.linkageExportForRS = true;
		}

		if(check0){
			if(item.linkageExportForAS != undefined)		item.linkageExportForAS = true;
		}

		if(check1){
			if(item.linkageExportForRS != undefined)		item.linkageExportForRS = true;
		}

		if(check2){
			if(item.linkageExportInFirstFrame != undefined)	item.linkageExportInFirstFrame = true;
		}


		// ActionScript3.0用設定
		if(ver == 3){
			// クラス名
			if(item.linkageClassName != undefined)			item.linkageClassName = str0;
			// 基本クラス名
			if(item.linkageBaseClass != undefined)			item.linkageBaseClass = str1;
			// URL名
			if(item.linkageURL != undefined)				item.linkageURL = url;

		// ActionScript1.0用設定
		}else if(ver == 1){
			// リンケージ名
			if(item.linkageIdentifier != undefined)			item.linkageIdentifier = str0;
			// URL名
			if(item.linkageURL != undefined)				item.linkageURL = url;

		// ActionScript2.0用設定
		}else{
			// リンケージ名
			if(item.linkageIdentifier != undefined)			item.linkageIdentifier = str0;
			// クラス名
			if(item.linkageClassName != undefined)			item.linkageClassName = str1;
			// URL名
			if(item.linkageURL != undefined)				item.linkageURL = url;
		}

		if(check0 || check1 || check3){
			fl.trace("【変更】シンボル名 : 『" + item.name + "』  識別子 : 『" + str0 + "』");
		}else{
			fl.trace("【変更】シンボル名 : 『" + item.name + "』");
		}

		return false;

	},null);

	fl.trace("【完了】変換処理が終了しました。");

	return true;
}



// ---------------------------------------------------------
//	アイテムに識別子をセット
// ---------------------------------------------------------
function ItemSetAsset(item,asset){
	if(item.linkageIdentifier != undefined){
		item.linkageIdentifier = asset;
	}else{
		// 致命的エラー
		return false;
	}
	
	return true;
}



// ---------------------------------------------------------
// 連結リストコンテナ作成
// ---------------------------------------------------------
function LinkedListContainerCreate(){
	var container = new Object();
	var pref = new Object();
	var post = new Object();
	pref.pref = null;
	pref.post = post;
	post.pref = pref;
	post.post = null;
	
	container.begin = pref;
	container.end = post;
	
	return container;
}


// ---------------------------------------------------------
// 連結リストコンテナの最前列に連結リストを登録
// ---------------------------------------------------------
function LinkedListContainerAttachUnShift(container,list){

	LinkedListRemove(list);

	var pref = container.begin;
	var post = pref.post;
	pref.post = list;
	post.pref = list;
	list.pref = pref;
	list.post = post;
}


// ---------------------------------------------------------
// 連結リストコンテナの最後尾に連結リストを登録
// ---------------------------------------------------------
function LinkedListContainerAttachPush(container,list){

	LinkedListRemove(list);

	var post = container.end;
	var pref = post.pref;
	pref.post = list;
	post.pref = list;
	list.pref = pref;
	list.post = post;
}


// ---------------------------------------------------------
// 連結リストコンテナが保有するリストを取得
// ---------------------------------------------------------
function LinkedListContainerGetData (container,func,param){
	// 子リスト
	var post = container.begin.post;
	while(true){
		if(post.post == null)	break;
		if(func(post,param))	return post;
		post = post.post;
	}
	
	return null;
}

// ---------------------------------------------------------
// 連結リストコンテナが保有するリストをスタックに積んで取得（コールバック関数中にリスト操作可）
// ---------------------------------------------------------
function LinkedListContainerGetDataStack (container,func,param){
	var stack = new Array();
	// 子リスト
	var post = container.begin.post;
	while(true){
		if(post.post == null)	break;
		stack.push(post);
		post = post.post;
	}

	var i;
	var num = stack.length;
	for(i=0;i<num;i++){
		var list = stack[i];
		if(func(list,param))	return list;
	}
	
	return null;
}




// ---------------------------------------------------------
// 連結リストを作成
// ---------------------------------------------------------
function LinkedListCreate (){
	return {
		pref : null,
		post : null,
		data : null
	};
}


// ---------------------------------------------------------
// 連結リストにデータをセット
// ---------------------------------------------------------
function LinkedListSetData (list,data){
	list.data = data;
}


// ---------------------------------------------------------
// 連結リストのデータを取得
// ---------------------------------------------------------
function LinkedListGetData (list){
	return list.data;
}


// ---------------------------------------------------------
// 連結リストの次に連結リストをセット（自分がコンテナに登録されている必要がある）
// ---------------------------------------------------------
function LinkedListAttachPref (list,child){

	LinkedListRemove(child);

	var post = list;
	var pref = post.pref;
	pref.post = child;
	post.pref = child;
	child.pref = pref;
	child.post = post;
}


// ---------------------------------------------------------
// 連結リストの前に連結リストをセット（自分がコンテナに登録されている必要がある）
// ---------------------------------------------------------
function LinkedListAttachPost (list,child){

	LinkedListRemove(child);

	var pref = list;
	var post = pref.post;
	pref.post = child;
	post.pref = child;
	child.pref = pref;
	child.post = post;
}

// ---------------------------------------------------------
// 連結リストを外す
// ---------------------------------------------------------
function LinkedListRemove (list){
	if(list.post){
		var pref = list.pref;
		var post = list.post;
		pref.post = post;
		post.pref = pref;
		list.pref = null;
		list.post = null;
		return true;
	}

	return false;
}



// ---------------------------------------------------------
// 文字列からハッシュ値を取得
// ---------------------------------------------------------
function StringGetHash(str){
	var hash = 0;
	var num = str.length;
	var i;
	for(i=0;i<num;i++){
		hash = 0x7FFFFFFF & (hash * 137 + str.charCodeAt(i));
	}
	
	return hash;
}


// ---------------------------------------------------------
// 文字列同士の比較
// ---------------------------------------------------------
function StringComp(str1,str2){
	// 標準コード
	str1 = StringGetStandard(str1);
	str2 = StringGetStandard(str2);

	// 大文字を小文字
	str1 = str1.toLowerCase();
	str2 = str2.toLowerCase();

	var str1_num = str1.length;
	var str2_num = str2.length;


	var str_max = (str1_num < str2_num) ? str1_num : str2_num;
	
	// 連番除去名が一致するか
	if(StringRemovalSequenceNumber(str1) == StringRemovalSequenceNumber(str2)){
		// 連番比較
		var seq1 = StringGetSequenceNumber(str1);
		var seq2 = StringGetSequenceNumber(str2);
		if(seq1 < seq2)	return  1;
		if(seq1 > seq2)	return -1;
		return 0;
	}

	var i;
	for(i=0;i<str_max;i++){
		var code1 = str1.charCodeAt(i);
		var code2 = str2.charCodeAt(i);

		if(code1 < code2)	return  1;
		if(code1 > code2)	return -1;
	}
	
	if(str1_num < str2_num) 	return  1;
	if(str1_num > str2_num) 	return -1;
	
	
	return 0;
}

// ---------------------------------------------------------
// アイテム名からフォルダ名を省いたアイテム名を取得
// ---------------------------------------------------------
function StringGetName(str){
	var start = 0;
	var id = 0;
	var num = 0;
	
	while(true){
		id = str.indexOf("/" , id);
		if(id < 0)	break;
		
		num ++;
		id += 1;
		start = id;
	}
	return str.slice(start, str.length);
}

// ---------------------------------------------------------
// アイテム名から連番を取得
// ---------------------------------------------------------
function StringGetSequenceNumber(str){
	var ret = 0;
	var d = 1;
	var i;
	for(i=str.length-1;i>=0;i--,d *= 10){
		var n = str.charCodeAt(i);

		// 半角文字
		if(n >= 48 && n <= 57){
			ret += (n - 48) * d;
			continue;
		}

		// 全角文字
		if(n >= 65296 && n <= 65305){
			ret += (n - 65296) * d;
			continue;
		}

		break;
	}

	return ret;
}

// ---------------------------------------------------------
// アイテム名から連番を省いたアイテム名を取得
// ---------------------------------------------------------
function StringRemovalSequenceNumber(str){
	var i;
	for(i=str.length-1;i>=0;i--){
		var n = str.charCodeAt(i);

		// 半角文字
		if(n >= 48 && n <= 57){
			continue;
		}

		// 全角文字
		if(n >= 65296 && n <= 65305){
			continue;
		}

		break;
	}

	return str.substr(0,i+1);
}

// ---------------------------------------------------------
// 標準コードに変換
// ---------------------------------------------------------
function StringGetStandard(str){
	var dst = "";
	
	var i;
	var num = str.length;
	for(i=0;i<num;i++){
		dst += String.fromCharCode(UnicodeGetCodeStandard(str.charCodeAt(i)));
	}

	return dst;
}


// ---------------------------------------------------------
// ハッシュコンテナを作成
// ---------------------------------------------------------
function HashContainerCreate(num){
	var container = new Object();
	container.num = num;
	
	container.hash = new Array();
	var i;
	for(i=0;i<num;i++){
		container.hash[i] = new Array();
	}
	
	return container;
}


// ---------------------------------------------------------
// ハッシュコンテナにデータを追加
// ---------------------------------------------------------
function HashContainerAttachData(container,list,hash){
	var id = hash % container.num;
	container.hash[id].push(list);
}


// ---------------------------------------------------------
// ハッシュコンテナにデータを追加
// ---------------------------------------------------------
function HashContainerGetData(container,hash,func,param){
	var id = hash % container.num;
	var i;
	var ary = container.hash[id];
	var num = ary.length;

	for(i=0;i<num;i++){
		if(func(ary[i],param))	return ary[i];
	}
	return null;
}



// ---------------------------------------------------------
// 標準コードに変換
// ---------------------------------------------------------
function UnicodeGetCodeStandard(code){
	var half_code = unicode_standard[code];
	if(half_code)	return half_code;
	return code;
}


// ---------------------------------------------------------
// 標準コードテーブル
// ---------------------------------------------------------
var unicode_standard = new Array();
unicode_standard[0x3000] = 0x0020;	// 　
unicode_standard[0xFF01] = 0x0021;	// ！
unicode_standard[0xFF02] = 0x0022;	// ＂
unicode_standard[0xFF03] = 0x0023;	// ＃
unicode_standard[0xFF04] = 0x0024;	// ＄
unicode_standard[0xFF05] = 0x0025;	// ％
unicode_standard[0xFF06] = 0x0026;	// ＆
unicode_standard[0xFF07] = 0x0027;	// ＇
unicode_standard[0xFF08] = 0x0028;	// （
unicode_standard[0xFF09] = 0x0029;	// ）
unicode_standard[0xFF0A] = 0x002A;	// ＊
unicode_standard[0xFF0B] = 0x002B;	// ＋
unicode_standard[0xFF0C] = 0x002C;	// ，
unicode_standard[0xFF0D] = 0x002D;	// －
unicode_standard[0xFF0E] = 0x002E;	// ．
unicode_standard[0xFF0F] = 0x002F;	// ／
unicode_standard[0xFF10] = 0x0030;	// ０
unicode_standard[0xFF11] = 0x0031;	// １
unicode_standard[0xFF12] = 0x0032;	// ２
unicode_standard[0xFF13] = 0x0033;	// ３
unicode_standard[0xFF14] = 0x0034;	// ４
unicode_standard[0xFF15] = 0x0035;	// ５
unicode_standard[0xFF16] = 0x0036;	// ６
unicode_standard[0xFF17] = 0x0037;	// ７
unicode_standard[0xFF18] = 0x0038;	// ８
unicode_standard[0xFF19] = 0x0039;	// ９
unicode_standard[0xFF1A] = 0x003A;	// ：
unicode_standard[0xFF1B] = 0x003B;	// ；
unicode_standard[0xFF1C] = 0x003C;	// ＜
unicode_standard[0xFF1D] = 0x003D;	// ＝
unicode_standard[0xFF1E] = 0x003E;	// ＞
unicode_standard[0xFF1F] = 0x003F;	// ？
unicode_standard[0xFF20] = 0x0040;	// ＠
unicode_standard[0xFF21] = 0x0041;	// Ａ
unicode_standard[0xFF22] = 0x0042;	// Ｂ
unicode_standard[0xFF23] = 0x0043;	// Ｃ
unicode_standard[0xFF24] = 0x0044;	// Ｄ
unicode_standard[0xFF25] = 0x0045;	// Ｅ
unicode_standard[0xFF26] = 0x0046;	// Ｆ
unicode_standard[0xFF27] = 0x0047;	// Ｇ
unicode_standard[0xFF28] = 0x0048;	// Ｈ
unicode_standard[0xFF29] = 0x0049;	// Ｉ
unicode_standard[0xFF2A] = 0x004A;	// Ｊ
unicode_standard[0xFF2B] = 0x004B;	// Ｋ
unicode_standard[0xFF2C] = 0x004C;	// Ｌ
unicode_standard[0xFF2D] = 0x004D;	// Ｍ
unicode_standard[0xFF2E] = 0x004E;	// Ｎ
unicode_standard[0xFF2F] = 0x004F;	// Ｏ
unicode_standard[0xFF30] = 0x0050;	// Ｐ
unicode_standard[0xFF31] = 0x0051;	// Ｑ
unicode_standard[0xFF32] = 0x0052;	// Ｒ
unicode_standard[0xFF33] = 0x0053;	// Ｓ
unicode_standard[0xFF34] = 0x0054;	// Ｔ
unicode_standard[0xFF35] = 0x0055;	// Ｕ
unicode_standard[0xFF36] = 0x0056;	// Ｖ
unicode_standard[0xFF37] = 0x0057;	// Ｗ
unicode_standard[0xFF38] = 0x0058;	// Ｘ
unicode_standard[0xFF39] = 0x0059;	// Ｙ
unicode_standard[0xFF3A] = 0x005A;	// Ｚ
unicode_standard[0xFF3B] = 0x005B;	// ［
unicode_standard[0xFF3C] = 0x005C;	// ＼
unicode_standard[0xFF3D] = 0x005D;	// ］
unicode_standard[0xFF3E] = 0x005E;	// ＾
unicode_standard[0xFF3F] = 0x005F;	// ＿
unicode_standard[0xFF40] = 0x0060;	// ｀
unicode_standard[0xFF41] = 0x0061;	// ａ
unicode_standard[0xFF42] = 0x0062;	// ｂ
unicode_standard[0xFF43] = 0x0063;	// ｃ
unicode_standard[0xFF44] = 0x0064;	// ｄ
unicode_standard[0xFF45] = 0x0065;	// ｅ
unicode_standard[0xFF46] = 0x0066;	// ｆ
unicode_standard[0xFF47] = 0x0067;	// ｇ
unicode_standard[0xFF48] = 0x0068;	// ｈ
unicode_standard[0xFF49] = 0x0069;	// ｉ
unicode_standard[0xFF4A] = 0x006A;	// ｊ
unicode_standard[0xFF4B] = 0x006B;	// ｋ
unicode_standard[0xFF4C] = 0x006C;	// ｌ
unicode_standard[0xFF4D] = 0x006D;	// ｍ
unicode_standard[0xFF4E] = 0x006E;	// ｎ
unicode_standard[0xFF4F] = 0x006F;	// ｏ
unicode_standard[0xFF50] = 0x0070;	// ｐ
unicode_standard[0xFF51] = 0x0071;	// ｑ
unicode_standard[0xFF52] = 0x0072;	// ｒ
unicode_standard[0xFF53] = 0x0073;	// ｓ
unicode_standard[0xFF54] = 0x0074;	// ｔ
unicode_standard[0xFF55] = 0x0075;	// ｕ
unicode_standard[0xFF56] = 0x0076;	// ｖ
unicode_standard[0xFF57] = 0x0077;	// ｗ
unicode_standard[0xFF58] = 0x0078;	// ｘ
unicode_standard[0xFF59] = 0x0079;	// ｙ
unicode_standard[0xFF5A] = 0x007A;	// ｚ
unicode_standard[0xFF5B] = 0x007B;	// ｛
unicode_standard[0xFF5C] = 0x007C;	// ｜
unicode_standard[0xFF5D] = 0x007D;	// ｝
unicode_standard[0xFF5E] = 0x007E;	// ～
unicode_standard[0xFF5F] = 0x2985;	// ? 
unicode_standard[0xFF60] = 0x2986;	// ? S
unicode_standard[0x3002] = 0xFF61;	// 。
unicode_standard[0x300C] = 0xFF62;	// 「
unicode_standard[0x300D] = 0xFF63;	// 」
unicode_standard[0x3001] = 0xFF64;	// 、
unicode_standard[0x30FB] = 0xFF65;	// ・
unicode_standard[0xFF66] = 0x30F2;	// ヲ
unicode_standard[0xFF67] = 0x30A1;	// ァ
unicode_standard[0xFF68] = 0x30A3;	// ィ
unicode_standard[0xFF69] = 0x30A5;	// ゥ
unicode_standard[0xFF6A] = 0x30A7;	// ェ
unicode_standard[0xFF6B] = 0x30A9;	// ォ
unicode_standard[0xFF6C] = 0x30E3;	// ャ
unicode_standard[0xFF6D] = 0x30E5;	// ュ
unicode_standard[0xFF6E] = 0x30E7;	// ョ
unicode_standard[0xFF6F] = 0x30C3;	// ッ
unicode_standard[0xFF70] = 0x30FC;	// ー
unicode_standard[0xFF71] = 0x30A2;	// ア
unicode_standard[0xFF72] = 0x30A4;	// イ
unicode_standard[0xFF73] = 0x30A6;	// ウ
unicode_standard[0xFF74] = 0x30A8;	// エ
unicode_standard[0xFF75] = 0x30AA;	// オ
unicode_standard[0xFF76] = 0x30AB;	// カ
unicode_standard[0xFF77] = 0x30AD;	// キ
unicode_standard[0xFF78] = 0x30AF;	// ク
unicode_standard[0xFF79] = 0x30B1;	// ケ
unicode_standard[0xFF7A] = 0x30B3;	// コ
unicode_standard[0xFF7B] = 0x30B5;	// サ
unicode_standard[0xFF7C] = 0x30B7;	// シ
unicode_standard[0xFF7D] = 0x30B9;	// ス
unicode_standard[0xFF7E] = 0x30BB;	// セ
unicode_standard[0xFF7F] = 0x30BD;	// ソ
unicode_standard[0xFF80] = 0x30BF;	// タ
unicode_standard[0xFF81] = 0x30C1;	// チ
unicode_standard[0xFF82] = 0x30C4;	// ツ
unicode_standard[0xFF83] = 0x30C6;	// テ
unicode_standard[0xFF84] = 0x30C8;	// ト
unicode_standard[0xFF85] = 0x30CA;	// ナ
unicode_standard[0xFF86] = 0x30CB;	// ニ
unicode_standard[0xFF87] = 0x30CC;	// ヌ
unicode_standard[0xFF88] = 0x30CD;	// ネ
unicode_standard[0xFF89] = 0x30CE;	// ノ
unicode_standard[0xFF8A] = 0x30CF;	// ハ
unicode_standard[0xFF8B] = 0x30D2;	// ヒ
unicode_standard[0xFF8C] = 0x30D5;	// フ
unicode_standard[0xFF8D] = 0x30D8;	// ヘ
unicode_standard[0xFF8E] = 0x30DB;	// ホ
unicode_standard[0xFF8F] = 0x30DE;	// マ
unicode_standard[0xFF90] = 0x30DF;	// ミ
unicode_standard[0xFF91] = 0x30E0;	// ム
unicode_standard[0xFF92] = 0x30E1;	// メ
unicode_standard[0xFF93] = 0x30E2;	// モ
unicode_standard[0xFF94] = 0x30E4;	// ヤ
unicode_standard[0xFF95] = 0x30E6;	// ユ
unicode_standard[0xFF96] = 0x30E8;	// ヨ
unicode_standard[0xFF97] = 0x30E9;	// ラ
unicode_standard[0xFF98] = 0x30EA;	// リ
unicode_standard[0xFF99] = 0x30EB;	// ル
unicode_standard[0xFF9A] = 0x30EC;	// レ
unicode_standard[0xFF9B] = 0x30ED;	// ロ
unicode_standard[0xFF9C] = 0x30EF;	// ワ
unicode_standard[0xFF9D] = 0x30F3;	// ン
unicode_standard[0x3099] = 0xFF9E;	// ?
unicode_standard[0x309A] = 0xFF9F;	// ?
unicode_standard[0xFFA0] = 0x3164;	// ?
unicode_standard[0xFFA1] = 0x3131;	// ?
unicode_standard[0xFFA2] = 0x3132;	// ?
unicode_standard[0xFFA3] = 0x3133;	// ?
unicode_standard[0xFFA4] = 0x3134;	// ?
unicode_standard[0xFFA5] = 0x3135;	// ?
unicode_standard[0xFFA6] = 0x3136;	// ?
unicode_standard[0xFFA7] = 0x3137;	// ?
unicode_standard[0xFFA8] = 0x3138;	// ?
unicode_standard[0xFFA9] = 0x3139;	// ?
unicode_standard[0xFFAA] = 0x313A;	// ?
unicode_standard[0xFFAB] = 0x313B;	// ?
unicode_standard[0xFFAC] = 0x313C;	// ?
unicode_standard[0xFFAD] = 0x313D;	// ?
unicode_standard[0xFFAE] = 0x313E;	// ?
unicode_standard[0xFFAF] = 0x313F;	// ?
unicode_standard[0xFFB0] = 0x3140;	// ?
unicode_standard[0xFFB1] = 0x3141;	// ?
unicode_standard[0xFFB2] = 0x3142;	// ?
unicode_standard[0xFFB3] = 0x3143;	// ?
unicode_standard[0xFFB4] = 0x3144;	// ?
unicode_standard[0xFFB5] = 0x3145;	// ?
unicode_standard[0xFFB6] = 0x3146;	// ?
unicode_standard[0xFFB7] = 0x3147;	// ?
unicode_standard[0xFFB8] = 0x3148;	// ?
unicode_standard[0xFFB9] = 0x3149;	// ?
unicode_standard[0xFFBA] = 0x314A;	// ?
unicode_standard[0xFFBB] = 0x314B;	// ?
unicode_standard[0xFFBC] = 0x314C;	// ?
unicode_standard[0xFFBD] = 0x314D;	// ?
unicode_standard[0xFFBE] = 0x314E;	// ?
unicode_standard[0xFFC2] = 0x314F;	// ?
unicode_standard[0xFFC3] = 0x3150;	// ?
unicode_standard[0xFFC4] = 0x3151;	// ?
unicode_standard[0xFFC5] = 0x3152;	// ?
unicode_standard[0xFFC6] = 0x3153;	// ?
unicode_standard[0xFFC7] = 0x3154;	// ?
unicode_standard[0xFFCA] = 0x3155;	// ?
unicode_standard[0xFFCB] = 0x3156;	// ?
unicode_standard[0xFFCC] = 0x3157;	// ?
unicode_standard[0xFFCD] = 0x3158;	// ?
unicode_standard[0xFFCE] = 0x3159;	// ?
unicode_standard[0xFFCF] = 0x315A;	// ?
unicode_standard[0xFFD2] = 0x315B;	// ?
unicode_standard[0xFFD3] = 0x315C;	// ?
unicode_standard[0xFFD4] = 0x315D;	// ?
unicode_standard[0xFFD5] = 0x315E;	// ?
unicode_standard[0xFFD6] = 0x315F;	// ?
unicode_standard[0xFFD7] = 0x3160;	// ?
unicode_standard[0xFFDA] = 0x3161;	// ?
unicode_standard[0xFFDB] = 0x3162;	// ?
unicode_standard[0xFFDC] = 0x3163;	// ?
unicode_standard[0xFFE0] = 0x00A2;	// ￠
unicode_standard[0xFFE1] = 0x00A3;	// ￡
unicode_standard[0xFFE2] = 0x00AC;	// ￢
unicode_standard[0xFFE3] = 0x00AF;	// ￣
unicode_standard[0xFFE4] = 0x00A6;	// ￤
unicode_standard[0xFFE5] = 0x00A5;	// ￥
unicode_standard[0xFFE6] = 0x20A9;	// ? 
unicode_standard[0x2502] = 0xFFE8;	// │
unicode_standard[0x2190] = 0xFFE9;	// ←
unicode_standard[0x2191] = 0xFFEA;	// ↑
unicode_standard[0x2192] = 0xFFEB;	// →
unicode_standard[0x2193] = 0xFFEC;	// ↓
unicode_standard[0x25A0] = 0xFFED;	// ■
unicode_standard[0x25CB] = 0xFFEE;	// ○